<?xml version="1.0" encoding="UTF-8" ?>
<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib uri="http://jakarta.apache.org/taglibs/bsf-2.0" prefix="bsf" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>Script Tag Library Example</title>
	<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>

<h1>Contact List</h1>

<table class="contactlist">
    <thead>
    <tr>
        <th>First Name</th>
        <th>Last Name</th>
        <th>Birthday</th>
        <th>&nbsp;</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
    <tr><td colspan="5"><hr/></td></tr>
<bsf:scriptlet language="jython">
# demonstrates that Java classes can be imported and re-named 
import java.util.Calendar as Calendar

# get list of people from session
people = session.getAttribute("personService").getPeople()

# demonstrates that functions are first-class objects in python
printf = out.println

for person in people:
    # demonstrates string formatting and member access 
    # (appropriate getter/setter is called on bean here - some other languages such as BeanShell allow direct access to private members via reflection)
    printf("<tr><td>%s</td><td>%s</td><td>" % (person.firstName, person.lastName))
    printf("%s/%s/%s" % (str(person.birthday.get(Calendar.DATE)), str(person.birthday.get(Calendar.MONTH) + 1), str(person.birthday.get(Calendar.YEAR))))
    printf("</td><td><a href=\"JythonController?target=edit&id=%s\"><img src=\"images/edit.png\" title=\"Edit\"/></a></td>" % (person.id))
    printf("<td><a href=\"JythonController?target=delete&id=%s\"><img src=\"images/delete.png\" title=\"Delete\"/></a></td></tr>" % (person.id))

</bsf:scriptlet>
</tbody></table>
<br />
<a href="JythonController?target=new">Create New Contact</a>
</body>
</html>